using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;


namespace DarkStrideToolbox
{
	/// <summary>
	/// Summary description for DSForm.
	/// </summary>
	public class DSWinForm : System.Windows.Forms.Form
	{
		#region Properties
		public event EventHandler MessageReceived;
		#endregion

		#region Events
		protected void OnMessageReceived( DSNativeMethods.WindowMessage oMsg )
		{
			DSMessageArgs oArgs = null;

			if( MessageReceived != null )
			{
				oArgs = new DSMessageArgs( oMsg );
				MessageReceived( this, oArgs );
			}
		}
		#endregion


		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public DSWinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.Size = new System.Drawing.Size(300,300);
			this.Text = "DSForm";
		}
		#endregion

		[System.Security.Permissions.PermissionSet(System.Security.Permissions.SecurityAction.Demand, Name="FullTrust")]
		protected override void WndProc( ref Message m )
		{
			DarkStrideToolbox.DSNativeMethods.WindowMessage oMsg = (DarkStrideToolbox.DSNativeMethods.WindowMessage)m.Msg;

			try
			{
				OnMessageReceived( oMsg );
			}
			catch( Exception oEx )
			{
				throw new System.Exception( "WndProc override in DSWinForm failed.",oEx );
			}
			finally
			{
				//pass the message on down even if we choke.
				base.WndProc( ref m );
			}
		}
	}

	public class DSMessageArgs: EventArgs 
	{
		public DSMessageArgs( DSNativeMethods.WindowMessage oMsg ) 
		{
			m_oMsg = oMsg;
		}

		private DSNativeMethods.WindowMessage m_oMsg;
		public DSNativeMethods.WindowMessage Msg
		{
			get
			{
				return( m_oMsg );
			}
		}
	}
}
